//------------------------------------------------------------------------------
// File: GlobalTasks.cs 
// Tasks that remain open for the entirety of the game 
//------------------------------------------------------------------------------

// Start all Global Task Vertices
function GlobalStartTasks::OnEnter(%this)
{
   TaskModifier.strMarkVertex("GlobalTasks", "GlobalStartTasks", $TSV_CMPLETE);
}

////////////////////////////////////////////////////////////////////////////////
// Unlocks Requirements for all XP buy Store items.
////////////////////////////////////////////////////////////////////////////////

// XpBuy Blacksmith
function XPBlacksmith::OnExit(%this)
{
   XPBuyBank.reqCheck0 = true;
   XPBuyGun.reqCheck0 = true;
   XPBuyPick.reqCheck0 = true;
   XPBuyAxe.reqCheck0 = true;
   XPBuyTrack.reqCheck0 = true;
}

// XpBuy Lumbermill
function XPLumbermill::OnExit(%this)
{
   XPBuyTownhall.reqCheck0 = true;
   XPBuyHotel.reqCheck0 = true;
   XPBuyBuildingFortification.reqCheck0 = true;
}

// XpBuy Ranch
function XPRanch::OnExit(%this)
{
   XPBuySmokehouse.reqCheck0 = true;
   XPBuyPigs.reqCheck0 = true;
   XPBuyCows.reqCheck0 = true;
}

// XpBuy General Store
function XPGeneralStore::OnExit(%this)
{
   XPBuyDynamite.reqCheck0 = true;
   XPBuyHealing.reqCheck0 = true;
}

// XpBuy Townhall
function XPTownhall::OnExit(%this)
{
  XPBuyStatue.reqCheck0 = true;
  XPBuyTownbell.reqCheck0 = true;  
}

////////////////////////////////////////////////////////////////////////////////
// Hero Death Tutorial
////////////////////////////////////////////////////////////////////////////////
function HeroDeathTutorial::onUpdate(%this)
{
   Parent::onUpdate(%this);
   
   if(herocharacter.isHealing) 
   {
      tsSendTaskPopUpDlg("ID_HeroDeathTut", "ID_HeroDeathTutorial", $TaskButton::Okay, "herocharacter");
      TaskModifier.strMarkVertex("GlobalTasks", "HeroDeathTutorial", $TSV_CMPLETE);
   }
}